%% "data.mat": 3-dimension data (0.5 not merged)
% copy from Excel file "data.xlsx" after sorting by id
switch_iplus1_1basic=zeros(66,6); % row: subject; column: s1 s3 s5 c5 c7 c9
switch_iplus1_2week=zeros(66,6);
switch_iplus1_3year=zeros(66,6);
switch_iplus1_4kid=zeros(66,6);
switch_iplus1_5health=zeros(66,6);
id=zeros(66,1);
probability=[0.1 0.3 0.5 0.5 0.7 0.9];

% 3-dimension data: subject-question-treatment
switch_iplus1=zeros(66,6,5); % 3rd dimension: basic week year kid health
switch_iplus1(:,:,1)=switch_iplus1_1basic;
switch_iplus1(:,:,2)=switch_iplus1_2week;
switch_iplus1(:,:,3)=switch_iplus1_3year;
switch_iplus1(:,:,4)=switch_iplus1_4kid;
switch_iplus1(:,:,5)=switch_iplus1_5health;
MatchingProbability=zeros(66,6,5);
AmbiguityNeutralProbability=zeros(66,6,5);
ID=zeros(66,6,5);
Treatment=zeros(66,6,5);
Choose=zeros(66,6,5); % whether by choice (1) or by complement (0)
Order=zeros(66,6,5); % whether week-basic-year-health-kid (0) or health-year-basic-week-kid (1)
for i=1:66
    for j=1:6
        for k=1:5
            % switching value --> matching probability
            if switch_iplus1(i,j,k)==0
                MatchingProbability(i,j,k)=0;
            else if switch_iplus1(i,j,k)==101
                    MatchingProbability(i,j,k)=1;
                else
                    MatchingProbability(i,j,k)=(switch_iplus1(i,j,k)-0.5)/100;
                end
            end
            AmbiguityNeutralProbability(i,j,k)=probability(1,j);
            ID(i,j,k)=id(i,1);
            Treatment(i,j,k)=k;
            Choose(i,j,k)=(j<4);
            Order(i,j,k)=(mod(i,2)==1);
        end
    end
end

% variables "MatchingProbability", "AmbiguityNeutralProbability", "ID", "Order", "Choose" and "Treatment" save as "data.mat"

% into STATA
DATA=[MatchingProbability(:) AmbiguityNeutralProbability(:) ID(:) Treatment(:) Choose(:) Order(:)];
csvwrite('DATA.csv',DATA)

%% "data_merge.mat": 3-dimension data (0.5 merged)
% merging 0.5 choice and complement
for i=1:66
    for k=1:5
        MatchingProbability34(i,k)=0.5*(MatchingProbability(i,3,k)+MatchingProbability(i,4,k));
    end
end
MatchingProbability(:,3,:)=MatchingProbability34;
MatchingProbability(:,4,:)=MatchingProbability(:,5,:);
MatchingProbability(:,5,:)=MatchingProbability(:,6,:);
MatchingProbability=MatchingProbability(:,1:5,:);

AmbiguityNeutralProbability=AmbiguityNeutralProbability(:,[1 2 3 5 6],:);
ID=ID(:,[1 2 3 5 6],:);
Order=Order(:,[1 2 3 5 6],:);
Treatment=Treatment(:,[1 2 3 5 6],:);

% variables "MatchingProbability", "AmbiguityNeutralProbability", "ID", "Order", and "Treatment" save as "data_merge.mat"

%% Table OA.1: Comparison of matching probabilities between two orderings: Mann-Whitney U tests p-values
% load "data_merged.mat"
for j=1:5 % a-neutral probability
    for k=1:5 % treatment
        [p_test(j,k,2),h_test(j,k,2)]=ranksum(MatchingProbability(find(Order(:,j,k)==0),j,k),MatchingProbability(find(Order(:,j,k)==1),j,k)); % Wilcoxon rank sum test / Mann-Whitney U-test
    end
end

%% Figure 5: Mean matching probability
% FONT & SIZE
set(0,'DefaultAxesFontName','Times New Roman')
set(0,'DefaultAxesFontSize',10)
set(0,'DefaultTextFontname','Times New Roman')
set(0,'DefaultTextFontSize',10)

% load "data_merged.mat"
mean(MatchingProbability);
for j=1:5
    for k=1:5
        mean_MatchingProbability(j,k)=ans(1,j,k);
    end
end
mean_AmbiguityNeutralProbability=[0.1;0.3;0.5;0.7;0.9];

plot(mean_AmbiguityNeutralProbability,mean_AmbiguityNeutralProbability,'--k',mean_AmbiguityNeutralProbability,mean_MatchingProbability(:,1),'-dk',mean_AmbiguityNeutralProbability,mean_MatchingProbability(:,2),'-+k',mean_AmbiguityNeutralProbability,mean_MatchingProbability(:,3),'-*k',mean_AmbiguityNeutralProbability,mean_MatchingProbability(:,4),'-ok',mean_AmbiguityNeutralProbability,mean_MatchingProbability(:,5),'-ks')
legend(' ambiguity neutral',' basic', ' week',' year', ' kid',' health','Location','northwest');
legend boxoff
axis([0,1,0,1])
xlabel('a-neutral probability j/10')
ylabel('matching probability m(j/10)')
set(gca,'YTick',[0 0.1 0.3 0.5 0.7 0.9 1])
set(gca,'XTick',[0 0.1 0.3 0.5 0.7 0.9 1])
set(gca,'Yticklabel',sprintf('%1.1f|',[0 0.1 0.3 0.5 0.7 0.9 1]))
set(gca,'Xticklabel',sprintf('%1.1f|',[0 0.1 0.3 0.5 0.7 0.9 1]))
set(gca,'TickDir','out')
set(gca,'box','off')

%% Figure OA.2: Matching probabilities per a-neutral probability and across treatments
% FONT & SIZE
set(0,'DefaultAxesFontName','Times New Roman')
set(0,'DefaultAxesFontSize',10)
set(0,'DefaultTextFontname','Times New Roman')
set(0,'DefaultTextFontSize',10)

% load "data_merged.mat"
for j=1:5
    for k=2:5
        subplot(5,4,k-1+(j-1)*4)
        plot(MatchingProbability(:,j,1),MatchingProbability(:,j,k),'.k')
        hold on
        plot([0:1],[0:1],'-k')
        plot([0 1],[AmbiguityNeutralProbability(1,j,1) AmbiguityNeutralProbability(1,j,1)],'-k')
        plot([AmbiguityNeutralProbability(1,j,1) AmbiguityNeutralProbability(1,j,1)],[0 1],'-k')
        box off
        axis([0 1 0 1])
        if (j==1)&&(k==2)
            xlabel('m(p) basic')
            ylabel('m(p) treatment')
        end
        if j<3
            set(gca,'xtick',[0 AmbiguityNeutralProbability(1,j,1) 0.5 1])
            set(gca,'ytick',[0 AmbiguityNeutralProbability(1,j,1) 0.5 1])
            else if j>3
                set(gca,'xtick',[0 0.5 AmbiguityNeutralProbability(1,j,1) 1])
                set(gca,'ytick',[0 0.5 AmbiguityNeutralProbability(1,j,1) 1])
            end
        end
    end
end

%% Table 2: Ambiguity attitudes per event
% load "data_merged.mat"
AmbiguityAversionIndex=AmbiguityNeutralProbability-MatchingProbability;
median(AmbiguityAversionIndex);
Table5_1=zeros(5,5,5); % 1st dimension: a-neutral probability; 2nd dimension: treatment; 3rd dimension: median, percentage, p-values (different from 0, 0.005, -0.005)
for j=1:5
    for k=1:5
        Table5_1(j,k,1)=ans(1,j,k);
        if Table5_1(j,k,1)>0
            Table5_1(j,k,2)=sum(AmbiguityAversionIndex(:,j,k)>0)/66;
        else
            Table5_1(j,k,2)=sum(AmbiguityAversionIndex(:,j,k)<0)/66;
        end
        [p,h]=signrank(AmbiguityAversionIndex(:,j,k),zeros(66,1)); % different from 0
        Table5_1(j,k,3)=p;
        % see footnote 9
        [p,h]=signrank(AmbiguityAversionIndex(:,j,k),0.005*ones(66,1)); % different from 0.005
        Table5_1(j,k,4)=p;
        [p,h]=signrank(AmbiguityAversionIndex(:,j,k),-0.005*ones(66,1)); % different from -0.005
        Table5_1(j,k,5)=p;
    end
end

%% Table OA.2: Correlation of AA_j with basic
TableWA_2=zeros(5,4,2); % 3rd dimension: R or P
for j=1:5
    for t=2:5
        [R,P]=corr(AmbiguityAversionIndex(:,j,1),AmbiguityAversionIndex(:,j,t),'Type','Spearman');
        TableWA_2(j,t-1,1)=R;
        TableWA_2(j,t-1,2)=P;
    end
end

%% Table 3: Overall ambiguity attitudes across treatments
% go to STATA: overall fittings

%% Individual parametric fittings
% Neo-Additive comes from grid-search
% load "data.mat"
% define function "NeoAdditve.m" and "SquaredDistance_NA.m"
GRID=zeros(201,3); % 1st dimension: s with step=0.005; 2nd dimension: c s SquaredDistance_NA
for i=1:66
    for k=1:5
        x=AmbiguityNeutralProbability(i,:,k);
        y=MatchingProbability(i,:,k);
        for g=1:401
            s=(g-1)/200;
            grid=zeros(1,g+200);
            for h=1:(g+200)
                c=(h-1)/200;
                grid(1,h)=SquaredDistance_NA(y,x,[c;s]);
            end
            GRID(g,3)=min(grid);
            GRID(g,1)=(mean(find(grid==min(grid)))-1)/200;
            GRID(g,2)=s;
        end
        m=find(GRID(:,3)==min(GRID(:,3)));
        NeoAdditive_cs(i,1,k)=mean(GRID(m,1));
        NeoAdditive_cs(i,2,k)=mean(GRID(m,2));
    end
end

for i=1:66
    for k=1:5
        NeoAdditive_ab(i,1,k)=1-NeoAdditive_cs(i,2,k);
        NeoAdditive_ab(i,2,k)=1-NeoAdditive_cs(i,2,k)-2*NeoAdditive_cs(i,1,k);
    end
end

% Goldstein&Einhorn, Prelec2, Prelec1, and Tversky&Kahneman come from STATA fitting
% add (0,0) and (1,1) as data points (to avoid 0 variance in matching probabilities for some subjects)
% these function forms pass through these 2 points naturally, so doesn't affect the estimation
for i=1:66
    for j=1:2
        for k=1:5
            AmbiguityNeutralProbability_add(i,j,k)=j-1;
            MatchingProbability_add(i,j,k)=j-1;
            Treatment_add(i,j,k)=k;
            ID_add(i,j,k)=i;
        end
    end
end
DATA_add=[MatchingProbability_add(:) AmbiguityNeutralProbability_add(:) ID(:) Treatment(:)];
csvwrite('DATA_add.csv',DATA_add)
% go to STATA: individual fitting
for t=1:330
    i=ID(t,1);
    k=Treatment(t,1);
    GoldsteinEinhorn_ab(i,1,k)=GE_a(t,1); 
    GoldsteinEinhorn_ab(i,2,k)=GE_b(t,1);
    Prelec2_ab(i,1,k)=P2_a(t,1); 
    Prelec2_ab(i,2,k)=P2_b(t,1);
    Prelec1_a(i,1,k)=P1_a(t,1); 
    TverskyKahneman_c(i,1,k)=TK_c(t,1);
end

%% Table 4: Correlations of individual ambiguity attitudes across treatments
Table5_3_NA_ab=zeros(5,5,3);
% 3rd dimension: 1) p-values of paired Wilcoxon signed rank tests; 2) correlation coefficients; 3) p-values of 2)
% upper triangle: b; lower triangle: a
a=NeoAdditive_ab(:,1,:);
b=NeoAdditive_ab(:,2,:);
for k=1:5
    for t=(k+1):5
        [p,h]=signrank(b(:,1,k),b(:,1,t));
        Table5_3_NA_ab(k,t,1)=p;
        [p,h]=signrank(a(:,1,k),a(:,1,t));
        Table5_3_NA_ab(t,k,1)=p;
        [R,P]=corr(b(:,1,k),b(:,1,t),'type','Spearman');
        Table5_3_NA_ab(k,t,2)=R;
        Table5_3_NA_ab(k,t,3)=P;
        [R,P]=corr(a(:,1,k),a(:,1,t),'type','Spearman');
        Table5_3_NA_ab(t,k,2)=R;
        Table5_3_NA_ab(t,k,3)=P;
    end
end

%% Table OA.3: Median individual indexes b and a across treatments
% go to STATA: individual fittings
TableWA_3=zeros(2,5,2);
for k=1:5
    for t=1:2
        TableWA_3(t,k,1)=median(NeoAdditive_ab(:,t,k));
        [TableWA_3(t,k,2),h]=signrank(NeoAdditive_ab(:,t,k),zeros(66,1));
    end
end

% comparison across treatments
% Friedman's test: comparing among basic, week, year
friedman(a(:,1:3),3)
friedman(b(:,1:3),3)
% one-sided tests
NA_ab_1sided=zeros(2,3,2);
% 1st dimension: >, <; 2nd: kid-basic, health-basic, health-kid; 3rd: a, b
[NA_ab_1sided(1,1,1),h]=signrank(a(:,1,4),a(:,1,1),'tail','right'); % a: kid>basic?
[NA_ab_1sided(2,1,1),h]=signrank(a(:,1,4),a(:,1,1),'tail','left'); % a: kid<basic?
[NA_ab_1sided(1,2,1),h]=signrank(a(:,1,5),a(:,1,1),'tail','right'); % a: health>basic?
[NA_ab_1sided(2,2,1),h]=signrank(a(:,1,5),a(:,1,1),'tail','left'); % a: health<basic?
[NA_ab_1sided(1,3,1),h]=signrank(a(:,1,5),a(:,1,4),'tail','right'); % a: health>kid?
[NA_ab_1sided(2,3,1),h]=signrank(a(:,1,5),a(:,1,4),'tail','left'); % a: health<kid?
[NA_ab_1sided(1,1,2),h]=signrank(b(:,1,4),b(:,1,1),'tail','right'); % b: kid>basic?
[NA_ab_1sided(2,1,2),h]=signrank(b(:,1,4),b(:,1,1),'tail','left'); % b: kid<basic?
[NA_ab_1sided(1,2,2),h]=signrank(b(:,1,5),b(:,1,1),'tail','right'); % b: health>basic?
[NA_ab_1sided(2,2,2),h]=signrank(b(:,1,5),b(:,1,1),'tail','left'); % b: health<basic?
[NA_ab_1sided(1,3,2),h]=signrank(b(:,1,5),b(:,1,4),'tail','right'); % b: health>kid?
[NA_ab_1sided(2,3,2),h]=signrank(b(:,1,5),b(:,1,4),'tail','left'); % b: health<kid?

%% Figure OA.3: Empirical joint distribution of individual indexes b and a
% FONT & SIZE
set(0,'DefaultAxesFontName','Times New Roman')
set(0,'DefaultAxesFontSize',10)
set(0,'DefaultTextFontname','Times New Roman')
set(0,'DefaultTextFontSize',10)

for k=1:5
    subplot(1,5,k)
    plot(NeoAdditive_ab(:,1,k),NeoAdditive_ab(:,2,k),'.k')
    box off
    axis([-0.5 1 -1 1])
    xlabel('a')
    ylabel('b')
    hold on
    plot([-0.5 1],[0 0],'-k')
    plot([0 0],[-1 1],'-k')
end

%% Table OA.4: Principal component analysis of event-dependent ambiguity aversion indexes
a=NeoAdditive_ab(:,1,:);
b=NeoAdditive_ab(:,2,:);
for k=1:5
    [COEFF,SCORE,latent,tsquare]=princomp(AmbiguityAversionIndex(:,:,k));
    for t=1:2
        Table5_4(1:5,t,k)=COEFF(:,t); % loadings on components
        Table5_4(6,t,k)=latent(t,1); % eigenvalue
        Table5_4(7,t,k)=latent(t,1)/sum(latent); % proportion of variance explained
        [R,P]=corr(SCORE(:,t),a(:,k),'Type','Spearman'); % correlation with a
        Table5_4(8,t,k)=R; 
        Table5_4(9,t,k)=P;
        [R,P]=corr(SCORE(:,t),b(:,k),'Type','Spearman'); % correlation with b
        Table5_4(10,t,k)=R; 
        Table5_4(11,t,k)=P;
    end
end

%% Table OA.5: Non-parametric principal component analysis of event-dependent ambiguity aversion indexes
AmbiguityAversionIndex_ranking=zeros(66,5,5);
for k=1:5
    for j=1:5
        [AmbiguityAversionIndex_ranking(:,j,k)]=tiedrank(AmbiguityAversionIndex(:,j,k));
    end
end
for k=1:5
    [COEFF,SCORE,latent,tsquare]=princomp(AmbiguityAversionIndex_ranking(:,:,k));
    for t=1:2
        Table4_5n(1:5,t,k)=COEFF(:,t); % loadings on components
        Table4_5n(6,t,k)=latent(t,1); % eigenvalue
        Table4_5n(7,t,k)=latent(t,1)/sum(latent); % proportion of variance explained
        [R,P]=corr(SCORE(:,t),a(:,k),'Type','Spearman'); % correlation with a
        Table4_5n(8,t,k)=R; 
        Table4_5n(9,t,k)=P;
        [R,P]=corr(SCORE(:,t),b(:,k),'Type','Spearman'); % correlation with b
        Table4_5n(10,t,k)=R; 
        Table4_5n(11,t,k)=P;
    end
end

%% Table 5: Violations of monotonicity and correlations between indexes
% violations of monotonicity
% load "data_merged.mat"
for k=1:5
    for i=1:66
        for j=1:4
            monotonicity(i,j,k)=(~(MatchingProbability(i,j,k)>MatchingProbability(i,j+1,k)));
        end
    end
    Table5_5(1,k)=1-sum(sum(monotonicity(:,:,k)))/66/4;
end

% correlations between indexes
for k=1:5
    [R,P]=corr(b(:,k),a(:,k),'Type','Spearman');
    Table5_5(2,k)=R;
    Table5_5(3,k)=P;
end

%% Table 6: Fit of parametric families: Akaikes information criterion (AIC)
%% Table OA.10: Fit of parametric families: Akaikes information criterion (AIC)
%% Table OA.9: Fit of parametric families: Bayesian information criterion (BIC)
% go to STATA: parametric fitting - by treatments

%% Table 7: Fitted parameters (significance level given by comparison with basic)
%% Table OA.11: Fitted parameters (significance level given by comparison with basic)
% go to STATA: parametric fitting - by treatments
% go to STATA: parametric fitting - comparisons

%% Table OA.6: Median individual fitted parameters (significance level by comparison with basic)
TableWA_5=zeros(8,5,2); % 3rd dimension: median and p-value (compared with 0)
for k=1:5
    for t=1:2
        TableWA_5(t,k,1)=median(NeoAdditive_cs(:,t,k));
        [TableWA_5(t,k,2),h]=signrank(NeoAdditive_cs(:,t,k),zeros(66,1));
    end
    for t=3:4
        TableWA_5(t,k,1)=median(GoldsteinEinhorn_ab(:,t-2,k));
        [TableWA_5(t,k,2),h]=signrank(GoldsteinEinhorn_ab(:,t-2,k),zeros(66,1));
    end
    for t=5:6
        TableWA_5(t,k,1)=median(Prelec2_ab(:,t-4,k));
        [TableWA_5(t,k,2),h]=signrank(Prelec2_ab(:,t-4,k),zeros(66,1));
    end
    for t=7
        TableWA_5(t,k,1)=median(Prelec1_a(:,t-6,k));
        [TableWA_5(t,k,2),h]=signrank(Prelec1_a(:,t-6,k),zeros(66,1));
    end
    for t=8
        TableWA_5(t,k,1)=median(TverskyKahneman_c(:,t-7,k));
        [TableWA_5(t,k,2),h]=signrank(TverskyKahneman_c(:,t-7,k),zeros(66,1));
    end
end

% comparisons across treatments are contained in the next section

%% Table OA.7: Correlations of parameters across treatments
% Neo-Additive c&s
TableWA_6_NA=zeros(5,5,3);
% 3rd dimension: 1) p-values of paired Wilcoxon signed rank tests; 2) correlation coefficients; 3) p-values of 2)
% upper triangle: s; lower triangle: c
c=NeoAdditive_cs(:,1,:);
s=NeoAdditive_cs(:,2,:);
for k=1:5
    for t=(k+1):5
        [p,h]=signrank(s(:,1,k),s(:,1,t));
        TableWA_6_NA(k,t,1)=p;
        [p,h]=signrank(c(:,1,k),c(:,1,t));
        TableWA_6_NA(t,k,1)=p;
        [R,P]=corr(s(:,1,k),s(:,1,t),'Type','Spearman');
        TableWA_6_NA(k,t,2)=R;
        TableWA_6_NA(k,t,3)=P;
        [R,P]=corr(c(:,1,k),c(:,1,t),'Type','Spearman');
        TableWA_6_NA(t,k,2)=R;
        TableWA_6_NA(t,k,3)=P;
    end
end
% Friedman's test: comparing among basic, week, year
friedman(c(:,1:3),3)
friedman(s(:,1:3),3)
% one-sided tests
NA_cs_1sided=zeros(2,3,2);
% 1st dimension: >, <; 2nd: kid-basic, health-basic, health-kid; 3rd: a, b
[NA_cs_1sided(1,1,1),h]=signrank(c(:,1,4),c(:,1,1),'tail','right'); % a: kid>basic?
[NA_cs_1sided(2,1,1),h]=signrank(c(:,1,4),c(:,1,1),'tail','left'); % a: kid<basic?
[NA_cs_1sided(1,2,1),h]=signrank(c(:,1,5),c(:,1,1),'tail','right'); % a: health>basic?
[NA_cs_1sided(2,2,1),h]=signrank(c(:,1,5),c(:,1,1),'tail','left'); % a: health<basic?
[NA_cs_1sided(1,3,1),h]=signrank(c(:,1,5),c(:,1,4),'tail','right'); % a: health>kid?
[NA_cs_1sided(2,3,1),h]=signrank(c(:,1,5),c(:,1,4),'tail','left'); % a: health<kid?
[NA_cs_1sided(1,1,2),h]=signrank(s(:,1,4),s(:,1,1),'tail','right'); % b: kid>basic?
[NA_cs_1sided(2,1,2),h]=signrank(s(:,1,4),s(:,1,1),'tail','left'); % b: kid<basic?
[NA_cs_1sided(1,2,2),h]=signrank(s(:,1,5),s(:,1,1),'tail','right'); % b: health>basic?
[NA_cs_1sided(2,2,2),h]=signrank(s(:,1,5),s(:,1,1),'tail','left'); % b: health<basic?
[NA_cs_1sided(1,3,2),h]=signrank(s(:,1,5),s(:,1,4),'tail','right'); % b: health>kid?
[NA_cs_1sided(2,3,2),h]=signrank(s(:,1,5),s(:,1,4),'tail','left'); % b: health<kid?

% Goldstein & Einhorn
TableWA_6_GE=zeros(5,5,3);
% 3rd dimension: 1) p-values of paired Wilcoxon signed rank tests; 2) correlation coefficients; 3) p-values of 2)
% upper triangle: b; lower triangle: a
a=GoldsteinEinhorn_ab(:,1,:);
b=GoldsteinEinhorn_ab(:,2,:);
for k=1:5
    for t=(k+1):5
        [p,h]=signrank(b(:,1,k),b(:,1,t));
        TableWA_6_GE(k,t,1)=p;
        [p,h]=signrank(a(:,1,k),a(:,1,t));
        TableWA_6_GE(t,k,1)=p;
        [R,P]=corr(b(:,1,k),b(:,1,t),'Type','Spearman');
        TableWA_6_GE(k,t,2)=R;
        TableWA_6_GE(k,t,3)=P;
        [R,P]=corr(a(:,1,k),a(:,1,t),'Type','Spearman');
        TableWA_6_GE(t,k,2)=R;
        TableWA_6_GE(t,k,3)=P;
    end
end
% Friedman's test: comparing among basic, week, year
friedman(a(:,1:3),3)
friedman(b(:,1:3),3)
% one-sided tests
GE_ab_1sided=zeros(2,3,2);
% 1st dimension: >, <; 2nd: kid-basic, health-basic, health-kid; 3rd: a, b
[GE_ab_1sided(1,1,1),h]=signrank(a(:,1,4),a(:,1,1),'tail','right'); % a: kid>basic?
[GE_ab_1sided(2,1,1),h]=signrank(a(:,1,4),a(:,1,1),'tail','left'); % a: kid<basic?
[GE_ab_1sided(1,2,1),h]=signrank(a(:,1,5),a(:,1,1),'tail','right'); % a: health>basic?
[GE_ab_1sided(2,2,1),h]=signrank(a(:,1,5),a(:,1,1),'tail','left'); % a: health<basic?
[GE_ab_1sided(1,3,1),h]=signrank(a(:,1,5),a(:,1,4),'tail','right'); % a: health>kid?
[GE_ab_1sided(2,3,1),h]=signrank(a(:,1,5),a(:,1,4),'tail','left'); % a: health<kid?
[GE_ab_1sided(1,1,2),h]=signrank(b(:,1,4),b(:,1,1),'tail','right'); % b: kid>basic?
[GE_ab_1sided(2,1,2),h]=signrank(b(:,1,4),b(:,1,1),'tail','left'); % b: kid<basic?
[GE_ab_1sided(1,2,2),h]=signrank(b(:,1,5),b(:,1,1),'tail','right'); % b: health>basic?
[GE_ab_1sided(2,2,2),h]=signrank(b(:,1,5),b(:,1,1),'tail','left'); % b: health<basic?
[GE_ab_1sided(1,3,2),h]=signrank(b(:,1,5),b(:,1,4),'tail','right'); % b: health>kid?
[GE_ab_1sided(2,3,2),h]=signrank(b(:,1,5),b(:,1,4),'tail','left'); % b: health<kid?

% Prelec 2-parameter
TableWA_6_Prelec2=zeros(5,5,3);
% 3rd dimension: 1) p-values of paired Wilcoxon signed rank tests; 2) correlation coefficients; 3) p-values of 2)
% upper triangle: b; lower triangle: a
a=Prelec2_ab(:,1,:);
b=Prelec2_ab(:,2,:);
for k=1:5
    for t=(k+1):5
        [p,h]=signrank(b(:,1,k),b(:,1,t));
        TableWA_6_Prelec2(k,t,1)=p;
        [p,h]=signrank(a(:,1,k),a(:,1,t));
        TableWA_6_Prelec2(t,k,1)=p;
        [R,P]=corr(b(:,1,k),b(:,1,t),'Type','Spearman');
        TableWA_6_Prelec2(k,t,2)=R;
        TableWA_6_Prelec2(k,t,3)=P;
        [R,P]=corr(a(:,1,k),a(:,1,t),'Type','Spearman');
        TableWA_6_Prelec2(t,k,2)=R;
        TableWA_6_Prelec2(t,k,3)=P;
    end
end
% Friedman's test: comparing among basic, week, year
friedman(a(:,1:3),3)
friedman(b(:,1:3),3)
% one-sided tests
Prelec2_ab_1sided=zeros(2,3,2);
% 1st dimension: >, <; 2nd: kid-basic, health-basic, health-kid; 3rd: a, b
[Prelec2_ab_1sided(1,1,1),h]=signrank(a(:,1,4),a(:,1,1),'tail','right'); % a: kid>basic?
[Prelec2_ab_1sided(2,1,1),h]=signrank(a(:,1,4),a(:,1,1),'tail','left'); % a: kid<basic?
[Prelec2_ab_1sided(1,2,1),h]=signrank(a(:,1,5),a(:,1,1),'tail','right'); % a: health>basic?
[Prelec2_ab_1sided(2,2,1),h]=signrank(a(:,1,5),a(:,1,1),'tail','left'); % a: health<basic?
[Prelec2_ab_1sided(1,3,1),h]=signrank(a(:,1,5),a(:,1,4),'tail','right'); % a: health>kid?
[Prelec2_ab_1sided(2,3,1),h]=signrank(a(:,1,5),a(:,1,4),'tail','left'); % a: health<kid?
[Prelec2_ab_1sided(1,1,2),h]=signrank(b(:,1,4),b(:,1,1),'tail','right'); % b: kid>basic?
[Prelec2_ab_1sided(2,1,2),h]=signrank(b(:,1,4),b(:,1,1),'tail','left'); % b: kid<basic?
[Prelec2_ab_1sided(1,2,2),h]=signrank(b(:,1,5),b(:,1,1),'tail','right'); % b: health>basic?
[Prelec2_ab_1sided(2,2,2),h]=signrank(b(:,1,5),b(:,1,1),'tail','left'); % b: health<basic?
[Prelec2_ab_1sided(1,3,2),h]=signrank(b(:,1,5),b(:,1,4),'tail','right'); % b: health>kid?
[Prelec2_ab_1sided(2,3,2),h]=signrank(b(:,1,5),b(:,1,4),'tail','left'); % b: health<kid?

% Prelec 1-parameter and Tversky & Kahneman
TableWA_6_Prelec1_TK=zeros(5,5,3);
% 3rd dimension: 1) p-values of paired Wilcoxon signed rank tests; 2) correlation coefficients; 3) p-values of 2)
% upper triangle: Tversky & Kahneman; lower triangle: Prelec 1-parameter
a=Prelec1_a;
c=TverskyKahneman_c;
for k=1:5
    for t=(k+1):5
        [p,h]=signrank(c(:,1,k),c(:,1,t));
        TableWA_6_Prelec1_TK(k,t,1)=p;
        [p,h]=signrank(a(:,1,k),a(:,1,t));
        TableWA_6_Prelec1_TK(t,k,1)=p;
        [R,P]=corr(c(:,1,k),c(:,1,t),'Type','Spearman');
        TableWA_6_Prelec1_TK(k,t,2)=R;
        TableWA_6_Prelec1_TK(k,t,3)=P;
        [R,P]=corr(a(:,1,k),a(:,1,t),'Type','Spearman');
        TableWA_6_Prelec1_TK(t,k,2)=R;
        TableWA_6_Prelec1_TK(t,k,3)=P;
    end
end
% Friedman's test: comparing among basic, week, year
friedman(a(:,1:3),3)
friedman(c(:,1:3),3)
% one-sided tests
Prelec1_TK_ac_1sided=zeros(2,3,2);
% 1st dimension: >, <; 2nd: kid-basic, health-basic, health-kid; 3rd: a, c
[Prelec1_TK_ac_1sided(1,1,1),h]=signrank(a(:,1,4),a(:,1,1),'tail','right'); % a: kid>basic?
[Prelec1_TK_ac_1sided(2,1,1),h]=signrank(a(:,1,4),a(:,1,1),'tail','left'); % a: kid<basic?
[Prelec1_TK_ac_1sided(1,2,1),h]=signrank(a(:,1,5),a(:,1,1),'tail','right'); % a: health>basic?
[Prelec1_TK_ac_1sided(2,2,1),h]=signrank(a(:,1,5),a(:,1,1),'tail','left'); % a: health<basic?
[Prelec1_TK_ac_1sided(1,3,1),h]=signrank(a(:,1,5),a(:,1,4),'tail','right'); % a: health>kid?
[Prelec1_TK_ac_1sided(2,3,1),h]=signrank(a(:,1,5),a(:,1,4),'tail','left'); % a: health<kid?
[Prelec1_TK_ac_1sided(1,1,2),h]=signrank(c(:,1,4),c(:,1,1),'tail','right'); % c: kid>basic?
[Prelec1_TK_ac_1sided(2,1,2),h]=signrank(c(:,1,4),c(:,1,1),'tail','left'); % c: kid<basic?
[Prelec1_TK_ac_1sided(1,2,2),h]=signrank(c(:,1,5),c(:,1,1),'tail','right'); % c: health>basic?
[Prelec1_TK_ac_1sided(2,2,2),h]=signrank(c(:,1,5),c(:,1,1),'tail','left'); % c: health<basic?
[Prelec1_TK_ac_1sided(1,3,2),h]=signrank(c(:,1,5),c(:,1,4),'tail','right'); % c: health>kid?
[Prelec1_TK_ac_1sided(2,3,2),h]=signrank(c(:,1,5),c(:,1,4),'tail','left'); % c: health<kid?

%% Table OA.8: Correlations between various ambiguity attitude measures per treatment
AmbiguityMeasures=zeros(66,8,5);
for i=1:66
    for k=1:5
        AmbiguityMeasures(i,1,k)=NeoAdditive_ab(i,2,k);
        AmbiguityMeasures(i,2,k)=NeoAdditive_ab(i,1,k);
        AmbiguityMeasures(i,3,k)=GoldsteinEinhorn_ab(i,2,k);
        AmbiguityMeasures(i,4,k)=GoldsteinEinhorn_ab(i,1,k);
        AmbiguityMeasures(i,5,k)=Prelec2_ab(i,2,k);
        AmbiguityMeasures(i,6,k)=Prelec2_ab(i,1,k);
        AmbiguityMeasures(i,7,k)=Prelec1_a(i,1,k);
        AmbiguityMeasures(i,8,k)=TverskyKahneman_c(i,1,k);
    end
end
AmbiguityMeasures_R=zeros(8,8,5);
AmbiguityMeasures_P=zeros(8,8,5);
for k=1:5
    for t1=1:8
        for t2=(t1+1):8
            [R,P]=corr(AmbiguityMeasures(:,t1,k),AmbiguityMeasures(:,t2,k),'Type','Spearman');
            AmbiguityMeasures_R(t1,t2,k)=R;
            AmbiguityMeasures_P(t1,t2,k)=P;
        end
    end
end

%% Figures in OA.12
% FONT & SIZE
set(0,'DefaultAxesFontName','Times New Roman')
set(0,'DefaultAxesFontSize',10)
set(0,'DefaultTextFontname','Times New Roman')
set(0,'DefaultTextFontSize',10)

% load "data_merged.mat"
t=['basic ';'week  ';'year  ';'kid   ';'health'];
for k=1:5
    figure('Name',t(k,1:6),'NumberTitle','off')
    for m=1:6
        for n=1:11
            i=11*(m-1)+n;
            subplot(6,11,i)
            plot(AmbiguityNeutralProbability(i,:,k),MatchingProbability(i,:,k),'-*k')
            title(num2str(i))
            axis([0 1 0 1])
            set(gca,'xtick',[])
            set(gca,'ytick',[])
            text(0.1,0.9,num2str(NeoAdditive_cs(i,1,k),'%.2f'))
            text(0.4,0.9,num2str(NeoAdditive_cs(i,2,k),'%.2f'))
            text(0.1,0.75,num2str(GoldsteinEinhorn_ab(i,1,k),'%.2f'))
            text(0.4,0.75,num2str(GoldsteinEinhorn_ab(i,2,k),'%.2f'))
            text(0.1,0.6,num2str(Prelec2_ab(i,1,k),'%.2f'))
            text(0.4,0.6,num2str(Prelec2_ab(i,2,k),'%.2f'))
            text(0.1,0.45,num2str(Prelec1_a(i,1,k),'%.2f'))
            text(0.1,0.3,num2str(TverskyKahneman_c(i,1,k),'%.2f'))
        end
    end
end